﻿/*
EventDispatcher++ beta 2 by Grant Skinner, http://gskinner.com/

Note that in order to use the following features with Macromedia UI
components, you must also utilize UIEventDispatcher++.

No documentation is provided with this beta release. Please see
http://gskinner.com/blog/ for information and documentation.

Please report any bugs, or feature requests to gdispatcher@gskinner.com
You may NOT re-distribute or sell this code in any form.

The EventDispatcher class should be completely interchangeable with the
mx.events.EventDispatcher class.
*/

class mx.events.EventDispatcher {
	static var $instance:EventDispatcher = undefined;
	
	static function initialize(p_obj:Object):Void {
		if ($instance == undefined) { $instance = new EventDispatcher; }
		p_obj.dispatchEvent = $instance.dispatchEvent;
		p_obj.dispatchQueue = $instance.dispatchQueue;
		p_obj.eventListenerExists = $instance.eventListenerExists;
		p_obj.addEventListener = $instance.addEventListener;
		p_obj.removeEventListener = $instance.removeEventListener;
		p_obj.removeAllEventListeners = $instance.removeAllEventListeners;
		
		trace("G! EventDispatcher");
	}
	
	// internal function to locate listeners:
	static function $indexOfListener(p_queue:Array,p_obj:Object,p_function:String):Number {
		var l:Number = p_queue.length;
		var i:Number = -1;
		while (++i < l) {
			var obj:Object = p_queue[i];
			if (obj.o == p_obj && obj.f == p_function) { return i; }
		}
		return -1;
	}
	static function _dispatchEvent(p_dispatchObj:Object,p_queue:Object,p_eventObj:Object) {
		var i:String;
		// trick from MM: fixes problem with users removing items from listeners while it executes.
		for (i in p_queue) {
			var o:Object = p_queue[i].o;
			var oType:String = typeof(o);
			var f:String = p_queue[i].f;
			trace("go");
			if (oType == "object" || oType == "movieclip") {
				if (o.handleEvent != undefined && f == undefined) {
					o.handleEvent(p_eventObj);
				} else {
					if (f == undefined) { f = p_eventObj.type; }
					o[f](p_eventObj);
					trace("called it: "+o+"  :"+f);
				}
			} else { // function
				o.apply(p_dispatchObj,[p_eventObj]);
			}
		}
	}
	
	// protected function used by UIEventDispatcher:
	function dispatchQueue(p_dispatchObj:Object,p_eventObj:Object) {
		trace("dispatch q: "+p_eventObj.type+"  :  "+arguments.join(" | "));
		var queue:Array = p_dispatchObj["__q_"+p_eventObj.type];
		if (queue != undefined) { EventDispatcher._dispatchEvent(p_dispatchObj,queue,p_eventObj); }
		queue = p_dispatchObj["__q_ALL_EVENTS"];
		if (queue != undefined) { EventDispatcher._dispatchEvent(p_dispatchObj,queue,p_eventObj); }
	}
	// another function used by UIEventDispatcher:
	static function _removeEventListener(p_queue:Array,p_event:String,p_obj:Object,p_function:String):Void {
		if (p_queue == undefined) { return; }
		var index:Number = EventDispatcher.$indexOfListener(p_queue,p_obj,p_function);
		if (index != -1) { p_queue.splice(index,1); }
	}
	
	// functions used by dispatchers:
	private function dispatchEvent(p_eventObj:Object):Void {
		trace("dispatch: "+arguments.join(" | "));
		if (p_eventObj.type == "ALL_EVENTS") { return; } // disallow triggering events of type "ALL"
		if (p_eventObj.target == undefined) { p_eventObj.target = this; }
		this[p_eventObj.type + "Handler"](p_eventObj);
		dispatchQueue(this,p_eventObj);
	}
	private function eventListenerExists(p_event:String,p_obj:Object,p_function:String):Boolean {
		return (EventDispatcher.$indexOfListener(this["__q_"+p_event],p_obj,p_function) != -1);
	}
	private function addEventListener(p_event:String,p_obj:Object,p_function:String):Void {
		trace("f: "+p_function);
		var queue:Array = this["__q_"+p_event];
		if (queue == undefined) { this["__q_"+p_event] = queue = []; _global.ASSetPropFlags(this,"__q_"+p_event,1); }
		trace("q: "+queue);
		if (EventDispatcher.$indexOfListener(queue,p_obj,p_function) == -1) { queue.push({o:p_obj,f:p_function}); }
	}
	private function removeEventListener(p_event:String,p_obj:Object,p_function:String):Void {
		var queue = this["__q_"+p_event];
		EventDispatcher._removeEventListener(queue,p_event,p_obj,p_function);
	}
	private function removeAllEventListeners(p_event:String):Void {
		if (p_event != undefined) { delete(this["__q_"+p_event]); }
	}
	
}